﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private CompetenceBL _CompetenceBL = null;

        public CompetenceBL Competence
        {
            get
            {
                if (_CompetenceBL == null)
                {
                    _CompetenceBL = new CompetenceBL(this);
                }

                return _CompetenceBL;
            }
        }

        public class CompetenceBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public CompetenceBL(ZSBELearning BL) : base(BL) { }

            public BO.Competence Restore(long? ID)
            {
                return BLP.DAL.Competence.Restore(ID);
            }

            public BO.Competence Restore(BO.CompetencePart CompetencePart)
            {
                return Restore(CompetencePart.CompetenceID);
            }

            public List<BO.Competence> Restore()
            {
                return BLP.DAL.Competence.Restore();
            }

            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.CompetencePart.Delete();
                    BLP.DAL.Competence.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.Competence Competence)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (Competence != null)
                {
                    try
                    {
                        List<BO.CompetencePart> _listCompetencePart = BLP.CompetencePart.Restore(Competence);

                        foreach (BO.CompetencePart _loopCompetencePart in _listCompetencePart)
                        {
                            _methodResult.Add(BLP.CompetencePart.Remove(_loopCompetencePart));
                        }

                        _methodResult.SetSuccess = BLP.DAL.Competence.Remove(Competence);
                    }
                    catch(Exception _exeption)
                    {
                        _methodResult.Add(_exeption);
                    }
                }
                return _methodResult;
            }

            public BO.Competence Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                if (BO != null && BO.ID.HasValue)
                {
                    return BLP.DAL.Competence.Restore(BO.ID);
                }
                else
                {
                    return null;
                }
            }

            public BO.Competence New(string Name)
            {
                BO.Competence _new = null;

                if (!String.IsNullOrEmpty(Name))
                {
                    _new = BLP.DAL.Competence.New();
                    _new.IsActive = false;
                    _new.Name = Name;
                    _new.Weight = BLP.DAL.Competence.Count() + 1;

                    BLP.DAL.Competence.Create(_new);
                }

                return _new;
            }

            public int Count()
            {
                return BLP.DAL.Competence.Count();
            }

            private ViewBL _view = null;

            public ViewBL View
            {
                get
                {
                    if (_view == null)
                    {
                        _view = new ViewBL(this.BLP);
                    }
                    return _view;
                }
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.Competence Competence)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (Competence == null)
                {
                    _methodResult.SetSuccess = false;
                }
                else
                {
                    if (Competence.ID.HasValue)
                    {
                        _methodResult.SetSuccess = BLP.DAL.Competence.Update(Competence);
                    }
                    else
                    {
                        _methodResult.SetSuccess = BLP.DAL.Competence.Create(Competence);
                    }
                }
                return _methodResult;
            }

            public bool Switch(BO.View.Competence CompetenceA, BO.View.Competence CompetenceB)
            {
                bool _return = true;

                BO.Competence _CompetenceA = Restore(CompetenceA);
                BO.Competence _CompetenceB = Restore(CompetenceB);

                _CompetenceA.Weight = CompetenceB.Weight;
                _CompetenceB.Weight = CompetenceA.Weight;

                _return &= Save(_CompetenceA).Success;
                _return &= Save(_CompetenceB).Success;

                CompetenceA.Weight = _CompetenceA.Weight;
                CompetenceB.Weight = _CompetenceB.Weight;

                _return &= RefresWeight();

                return _return;
            }

            public bool RefresWeight()
            {
                bool _return = true;

                List<BO.Competence> _listCompetence = BLP.DAL.Competence.Restore();

                int _weight = 1;
                foreach (BO.Competence _loopCompetence in _listCompetence)
                {
                    _loopCompetence.Weight = _weight;
                    _return &= BLP.DAL.Competence.Update(_loopCompetence);
                    _weight++;
                }

                return _return;
            }

            public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
            {
                public ViewBL(ZSBELearning BL) : base(BL) { }

                public List<BO.View.Competence> Restore()
                {
                    return BLP.DAL.CompetenceView.Restore();
                }

                public List<BO.View.Competence> Restore(BO.Competence.Search Search)
                {
                    return BLP.DAL.CompetenceView.Restore(Search);
                }

                public Gemini.Core.BL.Interface.BO.IBaseUnique<long?> RestoreByID(long? ID)
                {
                    return BLP.DAL.CompetenceView.Restore(ID);
                }

                public BO.View.Competence Restore(long? ID)
                {
                    return BLP.DAL.CompetenceView.Restore(ID);
                }

                public BO.View.Competence Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
                {
                    return BLP.DAL.CompetenceView.Restore(BO.ID);
                }
            }
        }
    }
}
